/*******************************************************
Filename		:  gen_idxstrg.sql
Release 		:  C2.0.3
SIR			:  
Description		:  creates set_idxstrg.sql file and runs to set index storage parameters except lob indexes.
Author			:  Ganesh Thadkamalla
Date			:  7/27/2004.
Comments		:  Run this script at the end of all ETL scripts.
**********************************************************/
set pagesize 0
set heading off
set linesize 200
set trimspool on
set echo off
set feedback off

spool set_idxstrg.sql
prompt set pagesize 1000
prompt set feedback on
prompt set echo on

prompt spool set_idxstrg.log

PROMPT --Atler Statements for PCTINCREASE are generated only if the tablespace extent management is dictionary.

SELECT 'ALTER INDEX STORETW.'||index_name||' STORAGE (PCTINCREASE 0);'
FROM USER_indexes
WHERE INDEX_TYPE !='LOB'
and exists (select 'x' from user_tablespaces
               where tablespace_name = 'STORETINDX'
                and extent_management='DICTIONARY');

prompt spool off;
spool off;

@set_idxstrg.sql

spool post_set_idxstrg.log

select index_name, pct_increase
from user_indexes
where (pct_increase !=0 and pct_increase is not null)
and index_type !='LOB';

spool off;

set pagesize 50;
set heading on;
set linesize 80;
set trimspool on;
set feedback on;